import { Component, OnInit, Input } from '@angular/core';
import { NgRedux, select } from 'ng2-redux';
import { IAppState } from '../../../store';

@Component({
  selector: 'app-concept-list',
  templateUrl: './concept-list.component.html',
  styleUrls: ['./concept-list.component.scss']
})
export class ConceptListComponent implements OnInit {
  @select(['conceptSearch', 'concepts']) concepts;
  @select(['system', 'focusedElement']) focusedElement;
  constructor(private ngRedux: NgRedux<IAppState>) {
  }

  getState() {
    return this.ngRedux.getState();
  }

  ngOnInit() {
  }

  currentMessage() {
    let state = this.getState();
    if (state.conceptSearch.searched === true) {
      if (!(state.conceptSearch.concepts.length > 0)) {
        return 'No matching Results';
      }
    } else if ( state.conceptSearch.searching === true) {
      return 'Searching...please wait';
    } 
  }

  conceptExists() {
    return this.getState().conceptSearch.concepts.length > 0 && this.getState().conceptSearch.concepts !== null ? true : false;
  }

}
